/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Attribute;
import att.grappa.Edge;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaNexus;
import att.grappa.Lexer;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
implements GrappaConstants {
    private Graph graph = null;
    private Subgraph subgraph = null;
    long visastamp = -1L;
    private boolean deleteCalled = false;
    private boolean busy = false;
    private static HashMap<String, Integer> userAttributeTypeMap = null;
    public Object object;
    public boolean visible = true;
    public boolean selectable = true;
    public int linewidth = 0;
    public static boolean usePrintList = false;
    public int counter = 0;
    public int highlight = 0;
    private Long idKey = null;
    String name = null;
    HashMap<String, Attribute> attributes = null;
    private static HashMap<Integer, Set<String>> AttrOfInterestCache = new HashMap();
    private static HashMap<Set<String>, String[]> AttrOfInterestCacheR = new HashMap();
    Set<String> attrsOfInterest = null;
    GrappaNexus grappaNexus = null;
    public boolean printAllAttributes = false;
    public boolean printDefaultAttributes = false;
    String canonName = null;
    static String[] ElementAttributesOfInterest = new String[]{"color", "fontcolor", "fontname", "fontsize", "fontstyle", "label"};
    private double patchSize = 0.0;
    private Rectangle2D.Double patch = null;

    protected Element() {
    }

    protected Element(int type, Subgraph subg) {
        this.setSubgraph(subg);
        this.setGraph(subg.getGraph());
        this.setIdKey(type);
        this.getGraph().addIdMapping(this);
        this.elementAttrsOfInterest();
    }

    private void elementAttrsOfInterest() {
        this.attrOfInterest(ElementAttributesOfInterest);
    }

    public abstract int getType();

    public boolean isNode() {
        return false;
    }

    public boolean isEdge() {
        return false;
    }

    public boolean isSubgraph() {
        return false;
    }

    abstract void setName();

    public String getName() {
        return this.name;
    }

    boolean reserve() {
        return this.setReserved(true, false);
    }

    void release() {
        this.setReserved(false, false);
    }

    boolean setDelete(boolean delete) {
        return this.setReserved(delete, true);
    }

    private synchronized boolean setReserved(boolean state, boolean isDelete) {
        if (isDelete) {
            if (state) {
                this.deleteCalled = true;
                if (this.busy) {
                    return false;
                }
                this.busy = true;
                return true;
            }
            this.busy = false;
            this.deleteCalled = false;
            return true;
        }
        if (state) {
            if (this.deleteCalled) {
                return false;
            }
            this.busy = true;
            return true;
        }
        if (!this.deleteCalled) {
            this.busy = false;
        } else {
            this.deleteCalled = false;
            this.busy = false;
            this.delete();
        }
        return true;
    }

    protected void attrOfInterest(String[] names) {
        Arrays.sort(names);
        int hash = Arrays.deepHashCode(names);
        if (this.attrsOfInterest == null) {
            this.attrsOfInterest = AttrOfInterestCache.get(hash);
            if (this.attrsOfInterest == null) {
                this.attrsOfInterest = new HashSet<String>();
                for (String name : names) {
                    this.attrsOfInterest.add(name);
                }
                AttrOfInterestCache.put(hash, this.attrsOfInterest);
                AttrOfInterestCacheR.put(this.attrsOfInterest, names);
            }
        } else {
            String[] oldNames = AttrOfInterestCacheR.get(this.attrsOfInterest);
            Object[] newNames = new String[oldNames.length + names.length];
            System.arraycopy(oldNames, 0, newNames, 0, oldNames.length);
            System.arraycopy(names, 0, newNames, oldNames.length, names.length);
            Arrays.sort(newNames);
            hash = Arrays.deepHashCode(newNames);
            this.attrsOfInterest = AttrOfInterestCache.get(hash);
            if (this.attrsOfInterest == null) {
                this.attrsOfInterest = new HashSet<String>();
                for (Object name : newNames) {
                    this.attrsOfInterest.add((String)name);
                }
                AttrOfInterestCache.put(hash, this.attrsOfInterest);
                AttrOfInterestCacheR.put(this.attrsOfInterest, (String[])newNames);
            }
        }
        if (this.attrsOfInterest != null && this.grappaNexus != null) {
            for (String name : names) {
                Attribute attr = this.getAttribute(name);
                if (attr == null) continue;
                attr.addListener(this.grappaNexus);
            }
        }
    }

    public Iterator<String> listAttrsOfInterest() {
        if (this.attrsOfInterest == null) {
            return Grappa.emptyStringIterator.iterator();
        }
        return this.attrsOfInterest.iterator();
    }

    public boolean isOfInterest(String name) {
        if (name == null || this.attrsOfInterest == null) {
            return false;
        }
        return this.attrsOfInterest.contains(name);
    }

    public Object setAttribute(Attribute attr) {
        if (attr == null) {
            return null;
        }
        return this.setAttribute(attr.getName(), attr.getValue());
    }

    public Object setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (name == null) {
            throw new IllegalArgumentException("cannot set an attribute using a null name");
        }
        Object oldValue = null;
        Attribute crntAttr = this.getLocalAttribute(name);
        if (crntAttr == null) {
            if (value == null) {
                return null;
            }
            if (value instanceof String && ((String)value).trim().length() == 0 && Attribute.attributeType(this.getType(), name) != 12) {
                return null;
            }
            crntAttr = new Attribute(this.getType(), name, value);
            this.attributes.put(name, crntAttr);
            if (this.grappaNexus != null && this.isOfInterest(name)) {
                crntAttr.addListener(this.grappaNexus);
            }
        } else {
            oldValue = crntAttr.getValue();
            if (value == null) {
                this.removeAttribute(name);
                return oldValue;
            }
            if (value instanceof String && ((String)value).trim().length() == 0 && Attribute.attributeType(this.getType(), name) != 12) {
                this.removeAttribute(name);
                return oldValue;
            }
            crntAttr.setValue(value);
        }
        if (crntAttr.hasChanged()) {
            crntAttr.notifyListeners(new Long(System.currentTimeMillis()));
        }
        return oldValue;
    }

    private Attribute removeAttribute(String name) {
        if (name == null) {
            return null;
        }
        Attribute dfltAttr = this.getDefaultAttribute(name);
        Attribute attr = null;
        if (this.attributes != null) {
            attr = this.attributes.remove(name);
        }
        if (attr == null) {
            return dfltAttr;
        }
        if (dfltAttr == null) {
            attr.setValue("");
        }
        attr.setChanged();
        attr.notifyListeners(new Object[]{dfltAttr, new Long(System.currentTimeMillis())});
        return dfltAttr;
    }

    public Object setDefaultAttribute(String name, Object value) {
        return this.setDefaultAttribute(this.getType(), name, value);
    }

    public Object setDefaultAttribute(int type, String name, Object value) {
        Object oldValue = null;
        Subgraph subg = this.getSubgraph();
        switch (type) {
            case 1: {
                oldValue = subg.setNodeAttribute(name, value);
                break;
            }
            case 2: {
                oldValue = subg.setEdgeAttribute(name, value);
                break;
            }
            case 4: {
                if (subg == null) break;
                oldValue = subg.setAttribute(name, value);
            }
        }
        return oldValue;
    }

    public Object setDefaultAttribute(Attribute attr) {
        return this.setDefaultAttribute(this.getType(), attr);
    }

    public Object setDefaultAttribute(int type, Attribute attr) {
        if (attr == null) {
            return null;
        }
        Object oldValue = null;
        Subgraph subg = this.getSubgraph();
        switch (type) {
            case 1: {
                oldValue = subg.setNodeAttribute(attr);
                break;
            }
            case 2: {
                oldValue = subg.setEdgeAttribute(attr);
                break;
            }
            case 4: {
                if (subg == null) break;
                oldValue = subg.setAttribute(attr);
            }
        }
        return oldValue;
    }

    public Iterator<String> getLocalAttributeKeys() {
        if (this.attributes == null) {
            return Grappa.emptyStringIterator.iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public Iterator<Attribute> getLocalAttributePairs() {
        if (this.attributes == null) {
            return Grappa.emptyAttributeIterator.iterator();
        }
        return this.attributes.values().iterator();
    }

    public Iterator<Attribute> getAttributePairs() {
        HashMap<String, Attribute> pairs = null;
        Attribute attr = null;
        Iterator<Attribute> enm = this.getLocalAttributePairs();
        if (enm.hasNext()) {
            pairs = new HashMap<String, Attribute>(32);
        }
        while (enm.hasNext()) {
            attr = enm.next();
            pairs.put(attr.getName(), attr);
        }
        switch (this.getType()) {
            case 1: {
                enm = this.getSubgraph().getNodeAttributePairs();
                break;
            }
            case 2: {
                enm = this.getSubgraph().getEdgeAttributePairs();
                break;
            }
            case 4: {
                enm = this.getLocalAttributePairs();
            }
        }
        if (pairs != null) {
            while (enm.hasNext()) {
                attr = enm.next();
                if (pairs.containsKey(attr.getName())) continue;
                pairs.put(attr.getName(), attr);
            }
            return pairs.values().iterator();
        }
        return enm;
    }

    public Attribute getLocalAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Attribute getThisAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        Attribute attr = this.attributes.get(key);
        if (attr == null) {
            return null;
        }
        Subgraph sg = this.getSubgraph();
        if (sg == null) {
            return attr;
        }
        if (attr == sg.getAttribute(key)) {
            return null;
        }
        return attr;
    }

    public Object getThisAttributeValue(String key) {
        Attribute attr = this.getThisAttribute(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public Attribute getDefaultAttribute(int type, String key) {
        Attribute value = null;
        Subgraph sg = null;
        sg = this.isSubgraph() ? (Subgraph)this : this.getSubgraph();
        if (sg == null) {
            return Graph.getGlobalAttribute(type, key);
        }
        switch (type) {
            case 1: {
                value = sg.getNodeAttribute(key);
                break;
            }
            case 2: {
                value = sg.getEdgeAttribute(key);
                break;
            }
            case 4: {
                value = sg.getLocalAttribute(key);
            }
        }
        return value;
    }

    public Attribute getDefaultAttribute(String key) {
        return this.getDefaultAttribute(this.getType(), key);
    }

    public Attribute getAttribute(String key) {
        Attribute attr = null;
        attr = this.getLocalAttribute(key);
        if (attr == null) {
            attr = this.getDefaultAttribute(key);
        }
        return attr;
    }

    public Object getAttributeValue(String key) {
        Object value = null;
        Attribute attr = this.getAttribute(key);
        if (attr != null) {
            value = attr.getValue();
        }
        return value;
    }

    public boolean hasAttributeForKey(String key) {
        return this.getAttribute(key) != null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Subgraph getSubgraph() {
        return this.subgraph;
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setSubgraph(Subgraph subgraph) {
        if (this.subgraph != null && this.subgraph != subgraph) {
            switch (this.getType()) {
                case 1: {
                    this.subgraph.removeNode(((Node)this).getName());
                    subgraph.addNode((Node)this);
                    break;
                }
                case 2: {
                    this.subgraph.removeEdge(((Edge)this).getName());
                    subgraph.addEdge((Edge)this);
                    break;
                }
                case 4: {
                    this.subgraph.removeSubgraph(((Subgraph)this).getName());
                    subgraph.addSubgraph((Subgraph)this);
                }
            }
        }
        if (this.subgraph != subgraph) {
            if (this.subgraph != null && this.subgraph.grappaNexus != null) {
                this.subgraph.clearBBox();
            }
            if (subgraph != null && subgraph.grappaNexus != null) {
                subgraph.clearBBox();
            }
        }
        this.subgraph = subgraph;
    }

    protected void clearBBox() {
        if (this.grappaNexus != null) {
            this.grappaNexus.bbox = null;
        }
        for (Subgraph prnt = this.getSubgraph(); prnt != null; prnt = prnt.getSubgraph()) {
            if (prnt.grappaNexus == null) continue;
            prnt.grappaNexus.bbox = null;
        }
    }

    public int getId() {
        return (int)(this.getIdKey() >> 3);
    }

    public Long getIdKey() {
        return this.idKey;
    }

    protected void setIdKey(int type) {
        this.idKey = Graph.idMapKey(type, this.getGraph().nextId(type));
    }

    public void printElement(PrintWriter out) {
        String indent = new String(this.getGraph().getIndent());
        if (Grappa.printVisibleOnly && (!this.visible || this.grappaNexus.style.invis)) {
            return;
        }
        out.print(indent + this.toString());
        this.getGraph().incrementIndent();
        this.printAttributes(out, indent);
        this.getGraph().decrementIndent();
        out.println();
    }

    private void printAttributes(PrintWriter out, String outerIndent) {
        String indent = new String(this.getGraph().getIndent());
        String prefix = " [";
        String suffix = Grappa.NEW_LINE + outerIndent + "];";
        boolean first = true;
        HashMap printlist = null;
        if (Grappa.usePrintList || usePrintList) {
            printlist = (HashMap)this.getAttributeValue("printlist");
        }
        Iterator<Attribute> attrs = null;
        if (Grappa.elementPrintAllAttributes || this.printAllAttributes) {
            attrs = this.getAttributePairs();
        } else if (this.attributes != null && !this.attributes.isEmpty()) {
            attrs = this.attributes.values().iterator();
        }
        if (attrs != null) {
            while (attrs.hasNext()) {
                Attribute attr = attrs.next();
                String key = attr.getName();
                if (printlist != null && printlist.get(key) == null || attr == null || !Grappa.elementPrintAllAttributes && !this.printAllAttributes && attr.equalsValue(this.getDefaultAttribute(key))) continue;
                if (first) {
                    first = false;
                    out.println(prefix);
                } else {
                    out.println(",");
                }
                out.print(indent + key + " = " + Element.canonString(attr.getStringValue()));
            }
        }
        if (this.getGraph().filterMode && this.isEdge()) {
            if (first) {
                first = false;
                out.println(prefix);
            } else {
                out.println(",");
            }
            out.print(indent + "__nAmE__ = " + Element.canonString(this.getName()));
        }
        if (!first) {
            out.print(suffix);
        }
    }

    public String toString() {
        if (this.canonName == null) {
            this.canonName = Element.canonString(this.name);
        }
        return this.canonName;
    }

    public static String canonString(String input) {
        String low;
        int len;
        if (input == null || (len = input.length()) == 0) {
            return "\"\"";
        }
        StringBuilder strbuf = new StringBuilder(len + 8);
        char[] array = input.toCharArray();
        boolean has_special = false;
        boolean isHTML = false;
        for (char c : array) {
            if (c == '\"') {
                strbuf.append('\\');
                has_special = true;
            } else if (!has_special && !Lexer.id_char(c)) {
                has_special = true;
            }
            strbuf.append(c);
        }
        String tmpstr = strbuf.toString().trim();
        if (tmpstr.startsWith("<") && tmpstr.endsWith(">")) {
            isHTML = true;
        }
        if (!has_special && len <= 8 && ((low = input.toLowerCase()).equals("node") || low.equals("edge") || low.equals("graph") || low.equals("digraph") || low.equals("subgraph") || low.equals("strict"))) {
            has_special = true;
        }
        if (has_special && !isHTML) {
            strbuf.append('\"');
            strbuf.insert(0, '\"');
        }
        return strbuf.toString();
    }

    public static final String typeString(int elemType, boolean uplow) {
        String type = null;
        switch (elemType) {
            case 1: {
                type = uplow ? "Node" : "node";
                break;
            }
            case 2: {
                type = uplow ? "Edge" : "edge";
                break;
            }
            case 4: {
                type = uplow ? "Subgraph" : "subgraph";
                break;
            }
            case 8: {
                type = uplow ? "Grappa" : "grappa";
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    public static String canonValue(String input) {
        if (input == null) {
            return null;
        }
        char[] array = input.toCharArray();
        int len = 0;
        boolean allDigits = true;
        for (char c : array) {
            if (Character.isUpperCase(c)) {
                array[len++] = Character.toLowerCase(c);
                allDigits = false;
                continue;
            }
            if (Character.isLowerCase(c)) {
                array[len++] = c;
                allDigits = false;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            array[len++] = c;
        }
        if (len == 0 || allDigits) {
            return null;
        }
        return new String(array, 0, len);
    }

    boolean deleteCalled() {
        return this.deleteCalled;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean delete() {
        if (!this.setDelete(true)) {
            return false;
        }
        String name = this.getName();
        if (this.attributes != null && this.grappaNexus != null) {
            for (Attribute attr : this.attributes.values()) {
                attr.removeListener(this.grappaNexus);
            }
        }
        Subgraph prnt = null;
        if (this.grappaNexus != null) {
            this.grappaNexus.bbox = null;
        }
        for (prnt = this.getSubgraph(); prnt != null; prnt = prnt.getSubgraph()) {
            if (prnt.grappaNexus == null) continue;
            prnt.grappaNexus.bbox = null;
        }
        switch (this.getType()) {
            case 1: {
                Edge[] edges;
                for (Edge edge : edges = ((Node)this).edgeElementsAsArray()) {
                    for (prnt = edge.getSubgraph(); prnt != null; prnt = prnt.getSubgraph()) {
                        if (prnt.grappaNexus == null) continue;
                        prnt.grappaNexus.bbox = null;
                    }
                    edge.delete();
                }
                this.getSubgraph().removeNode(name);
                break;
            }
            case 2: {
                ((Edge)this).getTail().removeEdge((Edge)this, false);
                ((Edge)this).getHead().removeEdge((Edge)this, true);
                this.getSubgraph().removeEdge(name);
                break;
            }
            case 4: {
                void var8_17;
                Subgraph[] subgraphs;
                Node[] nodes = ((Subgraph)this).nodeElementsAsArray();
                for (Node node : nodes) {
                    node.delete();
                }
                Edge[] edges = ((Subgraph)this).edgeElementsAsArray();
                for (Element element : edges) {
                    element.delete();
                }
                Subgraph[] arr$ = subgraphs = ((Subgraph)this).subgraphElementsAsArray();
                int len$ = arr$.length;
                boolean bl = false;
                while (var8_17 < len$) {
                    Subgraph subgraph = arr$[var8_17];
                    subgraph.delete();
                    ++var8_17;
                }
                if (this.getSubgraph() == null) break;
                this.getSubgraph().removeSubgraph(name);
            }
        }
        this.getGraph().removeIdMapping(this);
        if (this.grappaNexus != null) {
            this.grappaNexus.element = null;
            this.grappaNexus = null;
        }
        return true;
    }

    public void addTag(String tag) {
        if (tag == null || tag.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + tag + ")");
        }
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            attr = new Attribute(this.getType(), "tag", new HashMap());
            this.setAttribute(attr);
            attr = this.getAttribute("tag");
        }
        HashMap tags = (HashMap)attr.getValue();
        tags.put(tag, tag);
    }

    public boolean hasTag(String tag) {
        if (tag == null || tag.indexOf(44) >= 0) {
            throw new RuntimeException("tag value null or contains a comma (" + tag + ")");
        }
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return this.hasDefaultTag(tag);
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return false;
        }
        return tags.containsKey(tag);
    }

    public boolean hasLocalTag(String tag) {
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return false;
        }
        return tags.containsKey(tag);
    }

    public boolean hasDefaultTag(String tag) {
        Attribute attr = this.getDefaultAttribute("tag");
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return false;
        }
        return tags.containsKey(tag);
    }

    public boolean hasTags() {
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return this.hasDefaultTags();
        }
        HashMap tags = (HashMap)attr.getValue();
        return tags != null && tags.size() != 0;
    }

    public boolean hasLocalTags() {
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        return tags != null && tags.size() != 0;
    }

    public boolean hasDefaultTags() {
        Attribute attr = this.getDefaultAttribute("tag");
        if (attr == null) {
            return false;
        }
        HashMap tags = (HashMap)attr.getValue();
        return tags != null && tags.size() != 0;
    }

    public void removeTags() {
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return;
        }
        tags.clear();
    }

    public void removeTag(String tag) {
        Attribute attr = this.getLocalAttribute("tag");
        if (attr == null) {
            return;
        }
        HashMap tags = (HashMap)attr.getValue();
        if (tags == null || tags.size() == 0) {
            return;
        }
        tags.remove(tag);
    }

    public static int setUserAttributeType(String attrname, int attrtype) {
        Integer old;
        int oldtype = 0;
        Integer type = null;
        if (attrname == null || attrname.trim().length() == 0) {
            throw new IllegalArgumentException("supplied attribute name should be non-null and contain some non-blank characters");
        }
        if (attrtype < 0) {
            type = new Integer(attrtype);
        } else {
            switch (attrtype) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    type = new Integer(attrtype);
                }
            }
        }
        if (type == null) {
            throw new IllegalArgumentException("supplied type for attribute (" + attrname + ") should be less than zero or a recognized type value");
        }
        if (userAttributeTypeMap == null) {
            userAttributeTypeMap = new HashMap();
        }
        if ((old = userAttributeTypeMap.get(attrname)) != null) {
            oldtype = old;
        }
        userAttributeTypeMap.put(attrname, type);
        return oldtype;
    }

    public static int attributeType(String attrname) {
        int convtype = -1;
        if (attrname != null) {
            int hashCode = attrname.hashCode();
            if (hashCode == BBOX_HASH && attrname.equals("bb")) {
                convtype = 1;
            } else if (hashCode == COLOR_HASH && attrname.equals("color")) {
                convtype = 2;
            } else if (hashCode == FILLCOLOR_HASH && attrname.equals("fillcolor")) {
                convtype = 2;
            } else if (hashCode == FONTCOLOR_HASH && attrname.equals("fontcolor")) {
                convtype = 2;
            } else if (hashCode == FONTSIZE_HASH && attrname.equals("fontsize")) {
                convtype = 4;
            } else if (hashCode == FONTSTYLE_HASH && attrname.equals("fontstyle")) {
                convtype = 5;
            } else if (hashCode == HEIGHT_HASH && attrname.equals("height")) {
                convtype = 4;
            } else if (hashCode == LABEL_HASH && attrname.equals("label")) {
                convtype = 12;
            } else if (hashCode == LP_HASH && attrname.equals("lp")) {
                convtype = 9;
            } else if (hashCode == PATCH_HASH && attrname.equals("patch")) {
                convtype = 4;
            } else if (hashCode == PRINTLIST_HASH && attrname.equals("printlist")) {
                convtype = 6;
            } else if (hashCode == STYLE_HASH && attrname.equals("style")) {
                convtype = 13;
            } else if (hashCode == TAG_HASH && attrname.equals("tag")) {
                convtype = 6;
            } else if (hashCode != STYLE_HASH || !attrname.equals("style")) {
                Integer usertype;
                convtype = hashCode == WIDTH_HASH && attrname.equals("width") ? 4 : (userAttributeTypeMap != null ? ((usertype = userAttributeTypeMap.get(attrname)) == null ? 12 : usertype) : 12);
            }
        }
        return convtype;
    }

    public final void buildShape() {
        if (this.grappaNexus == null) {
            this.grappaNexus = new GrappaNexus(this);
            Attribute attr = null;
            for (String sAttr : this.attrsOfInterest) {
                attr = this.getAttribute(sAttr);
                if (attr == null) continue;
                attr.addListener(this.grappaNexus);
            }
        }
    }

    public GrappaNexus getGrappaNexus() {
        if (this.grappaNexus == null) {
            this.buildShape();
        }
        return this.grappaNexus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List bdfs(int steps) {
        ArrayList<Element> input = new ArrayList<Element>(1);
        input.add(this);
        ArrayList<List<Element>> layers = new ArrayList<List<Element>>();
        Graph graph = this.getGraph();
        synchronized (graph) {
            Element.doBDFS(this.getType(), steps, System.currentTimeMillis(), 0, input, layers);
        }
        return layers;
    }

    private static void doBDFS(int type, int depth, long stamp, int level, ArrayList<Element> inbox, ArrayList<List<Element>> layers) {
        int sz = inbox.size();
        if (sz == 0) {
            return;
        }
        layers.add(inbox);
        if (depth >= 0 && ++level > depth) {
            return;
        }
        ArrayList<Element> input = new ArrayList<Element>();
        for (int i = 0; i < sz; ++i) {
            Edge edge;
            Iterator<Subgraph> enm;
            Element elem = inbox.get(i);
            if (type == 4) {
                if (depth >= 0 && level > depth) continue;
                enm = ((Subgraph)elem).subgraphElements();
                while (enm.hasNext()) {
                    Subgraph subg = enm.next();
                    if (subg.visastamp == stamp) continue;
                    input.add(subg);
                    subg.visastamp = stamp;
                }
                continue;
            }
            if (type == 1) {
                if (depth >= 0 && level > depth) continue;
                enm = ((Node)elem).outEdgeElements();
                while (enm.hasNext()) {
                    edge = (Edge)((Object)enm.next());
                    if (!edge.goesForward() || edge.getHead().visastamp == stamp) continue;
                    input.add(edge.getHead());
                    edge.getHead().visastamp = stamp;
                }
                enm = ((Node)elem).inEdgeElements();
                while (enm.hasNext()) {
                    edge = (Edge)((Object)enm.next());
                    if (!edge.goesReverse() || edge.getTail().visastamp == stamp) continue;
                    input.add(edge.getTail());
                    edge.getTail().visastamp = stamp;
                }
                continue;
            }
            if (depth >= 0 && level > depth) continue;
            if (((Edge)elem).goesForward()) {
                enm = ((Edge)elem).getHead().outEdgeElements();
                while (enm.hasNext()) {
                    edge = (Edge)((Object)enm.next());
                    if (!edge.goesForward() || edge.visastamp == stamp) continue;
                    input.add(edge);
                    edge.visastamp = stamp;
                }
                enm = ((Edge)elem).getHead().inEdgeElements();
                while (enm.hasNext()) {
                    edge = (Edge)((Object)enm.next());
                    if (!edge.goesReverse() || edge.visastamp == stamp) continue;
                    input.add(edge);
                    edge.visastamp = stamp;
                }
            }
            if (!((Edge)elem).goesReverse()) continue;
            enm = ((Edge)elem).getTail().outEdgeElements();
            while (enm.hasNext()) {
                edge = (Edge)((Object)enm.next());
                if (!edge.goesForward() || edge.visastamp == stamp) continue;
                input.add(edge);
                edge.visastamp = stamp;
            }
            enm = ((Edge)elem).getTail().inEdgeElements();
            while (enm.hasNext()) {
                edge = (Edge)((Object)enm.next());
                if (!edge.goesReverse() || edge.visastamp == stamp) continue;
                input.add(edge);
                edge.visastamp = stamp;
            }
        }
        if (input.size() > 0) {
            Element.doBDFS(type, depth, stamp, level, input, layers);
        }
    }

    double getPatchSize() {
        return this.patchSize;
    }

    void setPatchSize(double val) {
        this.patchSize = val;
    }

    Rectangle2D.Double getPatch() {
        return this.patch;
    }

    void setPatch(Rectangle2D.Double p) {
        if (p == null) {
            this.patch = p;
        } else if (this.patch == null) {
            this.patch = new GrappaBox(p.getX(), p.getY(), p.getWidth(), p.getHeight());
        } else {
            this.patch.setRect(p.getX(), p.getY(), p.getWidth(), p.getHeight());
        }
    }

    void setPatch(double x, double y, double w, double h) {
        if (this.patch == null) {
            this.patch = new GrappaBox(x, y, w, h);
        } else {
            this.patch.setRect(x, y, w, h);
        }
    }
}

