/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerDrawer;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import java.io.PrintWriter;
import java.util.Iterator;

public class VisualizerVector
extends VisualizerDrawer {
    public VisualizerVector(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    public void draw(PrintWriter printWriter, VisualState visualState) {
        FullDomain[] fullDomainArray = visualState.getEntries().asDomainArray();
        FullDomain[] fullDomainArray2 = visualState.getRemovedValues(fullDomainArray);
        printWriter.println("<!-- Vector " + String.valueOf(this.context) + " -->");
        this.standardGrid(printWriter);
        for (int i = 1; i < fullDomainArray.length; ++i) {
            int n;
            Iterator iterator = fullDomainArray[i].iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                this.unitSquareSVG(printWriter, this.posX(i), this.posY(n), this.domainBasedColor(fullDomainArray[i]));
            }
            iterator = fullDomainArray2[i].iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                this.unitSquareSVG(printWriter, this.posX(i), this.posY(n), Colors.REMOVED_VALUE_COLOR);
            }
        }
        this.drawFocus(printWriter, visualState.getFocus());
        this.drawFailed(printWriter, visualState.getFailed());
    }

    protected void drawFocus(PrintWriter printWriter, VizFocus vizFocus) {
        if (this.isInFocus(vizFocus)) {
            double d = this.posX(vizFocus.getSingleIndex());
            double d2 = this.topY();
            this.hollowRectSVG(printWriter, d, d2, 1.0, this.height(), Colors.FOCUS_COLOR);
        }
    }

    protected void drawFailed(PrintWriter printWriter, VizFailed vizFailed) {
        if (this.isFailed(vizFailed)) {
            double d = this.posX(vizFailed.getSingleIndex());
            double d2 = this.topY();
            printWriter.println("<!-- " + String.valueOf(vizFailed) + " -->");
            this.hollowRectSVG(printWriter, d, d2, 1.0, this.height(), Colors.FAILED_COLOR);
            this.unitSquareSVG(printWriter, d, this.posY(vizFailed.getValue()), Colors.FAILED_COLOR);
        }
    }
}

