/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.EclipseConnectionImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AsyncEclipseQueue {
    private int id;
    private String name;
    private EclipseConnectionImpl eclipse;
    private boolean isClosed = false;
    private boolean systemQueue = false;
    private InputStream cachedInputStream = null;
    private OutputStream cachedOutputStream = null;

    AsyncEclipseQueue(int n, String string, EclipseConnectionImpl eclipseConnectionImpl) {
        this.eclipse = eclipseConnectionImpl;
        this.id = n;
        this.name = string;
    }

    int getID() {
        return this.id;
    }

    boolean isSystemQueue() {
        return this.systemQueue;
    }

    void setSystemQueue(boolean bl) {
        this.systemQueue = bl;
    }

    public void close() throws IOException {
        this.testClosed();
        this.close_cleanup();
        this.eclipse.closeAsyncEclipseStreamEclipseSide(this.id);
        this.eclipse.closeAsyncEclipseStreamJavaSide(this.id);
    }

    void close_cleanup() {
        this.isClosed = true;
    }

    private void testClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Operation not possible: stream closed.");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.testClosed();
        return this.cachedInputStream != null ? this.cachedInputStream : this.eclipse.getAsyncInputStream(this.id);
    }

    public OutputStream getOutputStream() throws IOException {
        this.testClosed();
        return this.cachedOutputStream != null ? this.cachedOutputStream : this.eclipse.getAsyncOutputStream(this.id);
    }
}

