/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.visualisation.ContainerViewer;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewableType;
import com.parctechnologies.eclipse.visualisation.ViewletArray;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class ViewletArrayViewer
extends ContainerViewer {
    private ViewletFactory viewletFactory;
    protected ViewletRange previousUpdatingElementIndices;
    private final Atom vcSupportAtom = new Atom("vc_support");

    protected ViewletFactory getViewletFactory() {
        return this.viewletFactory;
    }

    public void setViewletFactory(ViewletFactory viewletFactory) {
        this.viewletFactory = viewletFactory;
    }

    public void setViewletType(ViewletType viewletType) {
        this.viewletType = viewletType;
        this.setViewletFactory((ViewletFactory)((Object)viewletType));
    }

    public ViewletArrayViewer(ViewletType viewletType, VisClientStateModel visClientStateModel, Viewable viewable) {
        super(visClientStateModel, viewable, viewletType);
        this.setViewletFactory((ViewletFactory)((Object)viewletType));
        this.previousUpdatingElementIndices = null;
    }

    public ViewletData getViewletAt(List list) {
        return this.viewletDataStore.getViewletDataAt(list);
    }

    @Override
    public Collection getViewletDataAt(List list) {
        LinkedList<ViewletData> linkedList = new LinkedList<ViewletData>();
        linkedList.add(this.getViewletAt(list));
        return linkedList;
    }

    @Override
    public void prepareForEvent(VisEvent visEvent) {
        if (visEvent instanceof CreateEvent) {
            this.prepareForCreate((CreateEvent)visEvent);
        }
        if (visEvent instanceof ExpandEvent) {
            this.prepareForExpand((ExpandEvent)visEvent);
        }
        super.prepareForEvent(visEvent);
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        if (visEvent instanceof UpdateEvent) {
            this.viewletDataStore.fireViewletRangeUpdated(this.previousUpdatingElementIndices);
            super.startEvent(visEvent, list);
            this.viewletDataStore.fireViewletRangeUpdated(this.getUpdatingElementIndices());
            this.previousUpdatingElementIndices = this.getUpdatingElementIndices();
            return;
        }
        if (visEvent instanceof CreateEvent) {
            super.startEvent(visEvent, list);
            for (int i = 1; i <= this.viewletDataStore.getNDimensions(); ++i) {
                this.viewletDataStore.setLocationNames(i, this.getLocationNames(i));
            }
            return;
        }
        if (visEvent instanceof ExpandEvent) {
            super.startEvent(visEvent, list);
            int n = ((ExpandEvent)visEvent).getExpandingDimension();
            this.viewletDataStore.finishExpandDimension(n);
            return;
        }
        super.startEvent(visEvent, list);
    }

    @Override
    public void stopEvent() {
        if (this.getCurrentEvent() instanceof ContractEvent) {
            this.stopContract((ContractEvent)this.getCurrentEvent());
        }
        super.stopEvent();
    }

    private void prepareForCreate(CreateEvent createEvent) {
        this.viewletDataStore = new ViewletArray(createEvent.getViewableSize(), ((ViewableType.ArrayType)createEvent.getViewableType()).getFixityList(), this.getViewable(), this.viewletFactory);
        this.viewletDataStore.setSymRef(new SymRef(this.viewletDataStore, this.getSymRef(), "store"));
    }

    private void prepareForExpand(ExpandEvent expandEvent) {
        this.viewletDataStore.startExpandDimension(expandEvent.getExpandingDimension());
    }

    private void stopContract(ContractEvent contractEvent) {
        this.viewletDataStore.shrinkTo(contractEvent.getViewableSize());
    }

    @Override
    protected ViewletRange getAllViewletData() {
        return this.viewletDataStore.getEntireViewletRange();
    }
}

