/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.visualisation.AbstractViewletDataStore;
import com.parctechnologies.eclipse.visualisation.MultiViewletDataStore;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletRangeCollection;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.WrappedMultiViewletDataStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparseViewletStore
extends AbstractViewletDataStore
implements MultiViewletDataStore {
    private Map wrappedStoreMap;
    private List fixity;
    private Map elements;

    public SparseViewletStore(List list, List list2, Viewable viewable) {
        super(list, list2, viewable, null);
        this.fixity = list2;
        this.elements = new HashMap();
    }

    @Override
    public ViewletRange getEntireViewletRange() {
        return new ViewletRangeCollection((Collection)this.elements.keySet());
    }

    @Override
    public void shrinkTo(List list) {
        super.shrinkTo(list);
        this.fireTableStructureChanged();
    }

    @Override
    public void startExpandDimension(int n) {
        super.startExpandDimension(n);
    }

    @Override
    public ViewletData getViewletDataAt(List list) {
        if (list.size() != this.getSize().size()) {
            throw new IllegalArgumentException();
        }
        return (ViewletData)this.getElement(list);
    }

    @Override
    public void setViewletDataAt(List list, ViewletData viewletData) {
        if (list.size() != this.getSize().size()) {
            throw new IllegalArgumentException();
        }
        if (viewletData != null) {
            this.setElement(list, viewletData);
        } else {
            this.removeElement(list);
        }
    }

    private Object getElement(List list) {
        Object v = this.elements.get(list);
        return v;
    }

    private void setElement(List list, Object object) {
        this.elements.put(list, object);
    }

    private void removeElement(List list) {
        this.elements.remove(list);
    }

    @Override
    public ViewletRange createRange(Collection collection) {
        ViewletRangeCollection viewletRangeCollection = new ViewletRangeCollection();
        for (Object e : collection) {
            if (this.elements.get(e) == null) continue;
            viewletRangeCollection.add(e);
        }
        return viewletRangeCollection;
    }

    @Override
    public ViewletRange createRange(List list, List list2) {
        ViewletRange viewletRange = super.createRange(list, list2);
        ViewletRangeCollection viewletRangeCollection = new ViewletRangeCollection();
        for (Object e : viewletRange) {
            if (this.elements.get(e) == null) continue;
            viewletRangeCollection.add(e);
        }
        return viewletRangeCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewletDataStore getViewletDataStore(ViewletType viewletType) {
        ViewletDataStore viewletDataStore;
        if (this.wrappedStoreMap == null) {
            viewletDataStore = this;
            synchronized (viewletDataStore) {
                if (this.wrappedStoreMap == null) {
                    this.wrappedStoreMap = new HashMap();
                }
            }
        }
        if ((viewletDataStore = (ViewletDataStore)this.wrappedStoreMap.get(viewletType)) == null) {
            SparseViewletStore sparseViewletStore = this;
            synchronized (sparseViewletStore) {
                if (viewletDataStore == null) {
                    viewletDataStore = new WrappedMultiViewletDataStore(this, viewletType);
                    viewletDataStore.setSymRef(new SymRef(viewletDataStore, this.getSymRef(), viewletType.getClass().getName()));
                    this.wrappedStoreMap.put(viewletType, viewletDataStore);
                }
            }
        }
        return viewletDataStore;
    }
}

